% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_compile.R
\name{tf_compile_model}
\alias{tf_compile_model}
\title{Compile a Keras model for truncated data under dist}
\usage{
tf_compile_model(
  inputs,
  intermediate_output,
  dist,
  optimizer,
  censoring = TRUE,
  truncation = TRUE,
  metrics = NULL,
  weighted_metrics = NULL
)
}
\arguments{
\item{inputs}{List of keras input layers}

\item{intermediate_output}{Intermediate model layer to be used as input to
distribution parameters}

\item{dist}{A \code{Distribution} to use for compiling the loss and parameter
outputs}

\item{optimizer}{String (name of optimizer) or optimizer instance. See
\verb{optimizer_*} family.}

\item{censoring}{A flag, whether the compiled model should support censored
observations. Set to \code{FALSE} for higher efficiency. \code{fit(...)} will error if
the resulting model is used to fit censored observations.}

\item{truncation}{A flag, whether the compiled model should support truncated
observations. Set to \code{FALSE} for higher efficiency. \code{fit(...)} will warn if
the resuting model is used to fit truncated observations.}

\item{metrics}{List of metrics to be evaluated by the model during
training and testing. Each of these can be:
\itemize{
\item a string (name of a
built-in function),
\item a function, optionally with a \code{"name"} attribute or
\item a \code{\link[keras3:Metric]{Metric()}}
instance. See the \verb{metric_*} family of functions.
}

Typically you will use
\code{metrics = c('accuracy')}. A function is any callable with the
signature \code{result = fn(y_true, y_pred)}. To specify different
metrics for different outputs of a multi-output model, you could
also pass a named list, such as
\code{metrics = list(a = 'accuracy', b = c('accuracy', 'mse'))}.
You can also pass a list to specify a metric or a list of
metrics for each output, such as
\code{metrics = list(c('accuracy'), c('accuracy', 'mse'))}
or \code{metrics = list('accuracy', c('accuracy', 'mse'))}. When you pass
the strings \code{'accuracy'} or \code{'acc'}, we convert this to one of
\code{metric_binary_accuracy()},
\code{metric_categorical_accuracy()},
\code{metric_sparse_categorical_accuracy()} based on the
shapes of the targets and of the model output. A similar
conversion is done for the strings \code{"crossentropy"}
and \code{"ce"} as well.
The metrics passed here are evaluated without sample weighting;
if you would like sample weighting to apply, you can specify
your metrics via the \code{weighted_metrics} argument instead.

If providing an anonymous R function, you can customize the printed name
during training by assigning \verb{attr(<fn>, "name") <- "my_custom_metric_name"},
or by calling \code{\link[keras3:custom_metric]{custom_metric("my_custom_metric_name", <fn>)}}}

\item{weighted_metrics}{List of metrics to be evaluated and weighted by
\code{sample_weight} or \code{class_weight} during training and testing.}
}
\value{
A \code{reservr_keras_model} that can be used to train truncated
and censored observations from \code{dist} based on input data from \code{inputs}.
}
\description{
Compile a Keras model for truncated data under dist
}
\examples{
dist <- dist_exponential()
params <- list(rate = 1.0)
N <- 100L
rand_input <- runif(N)
x <- dist$sample(N, with_params = params)

if (interactive()) {
  tf_in <- keras3::layer_input(1L)
  mod <- tf_compile_model(
    inputs = list(tf_in),
    intermediate_output = tf_in,
    dist = dist,
    optimizer = keras3::optimizer_adam(),
    censoring = FALSE,
    truncation = FALSE
  )
}

}
