% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.R
\name{bc}
\alias{bc}
\alias{bc_inv}
\alias{bc_prime}
\title{Box-Cox transformation}
\usage{
bc(x, lambda)

bc_inv(y, lambda)

bc_prime(y, lambda)
}
\arguments{
\item{x, y}{Numeric vector (\code{x} must be >= 0).}

\item{lambda}{Numeric scalar, power parameter.}
}
\value{
\code{bc()}: Returns the transform value(s).

\code{bc_inv()}: Computes the inverse of \code{bc()}.

\code{bc_prime()}: Gives the derivative of \code{bc()}
  with respect to \code{y}.
}
\description{
These functions calculate the Box-Cox transformation, its inverse, and derivative.
}
\details{
\code{bc()} uses \code{expm1()}, wich is more accurate
 for small \code{lambda} than a more "obvious" alternative like
 \preformatted{  if (abs(lambda) < 6e-9) log(y)
 else (y^lambda - 1) / lambda} The difference might be important
 in optimization applications. See example below. Similarly,
 \code{bc_inv()} uses \code{log1p()}.
}
\section{Functions}{
\itemize{
\item \code{bc()}: The Box-Cox transformation

\item \code{bc_inv()}: Inverse of the Box-Cox transformation

\item \code{bc_prime()}: Derivative of the Box-Cox transformation

}}
\examples{
bc(0.5, 1.5)
bc(1, 0)
obvious <- function(lambda){(0.6^lambda - 1) / lambda} # at y = 0.6
plot(obvious, xlab="lambda", xlim=c(1e-6, 1e-9), log="x")

bc_inv(-0.4, 1.5)
bc_inv(0, 0)

bc_prime(0.5, 1.5)
bc_prime(1, 0)

}
