% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.remstats}
\alias{summary.remstats}
\title{Relational Event Network Statistics Summaries}
\usage{
\method{summary}{remstats}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link{remstats}}.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
The summaries provide information for each statistic included in the 
remstats object, offering insights into the distribution and characteristics 
of the data.
}
\description{
Produce summaries of each statistic from a \code{\link{remstats}} object.
}
\examples{
rehObject <- remify::remify(edgelist = history, model = "tie")
remstatsObject <- remstats::remstats(reh = rehObject, tie_effects = ~ remstats::inertia())
summary(remstatsObject)

rehObject <- remify::remify(edgelist = history, model = "actor")
remstatsObject <- remstats::remstats(reh = rehObject, receiver_effects = ~ inertia())
summary(remstatsObject)

}
