% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_create_custom_emoji}
\alias{lemmy_create_custom_emoji}
\title{Create a new custom emoji}
\usage{
lemmy_create_custom_emoji(
  category,
  shortcode,
  image_url,
  alt_text,
  keywords,
  auth,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{category}{A character value.}

\item{shortcode}{A character value.}

\item{image_url}{A character value.}

\item{alt_text}{A character value.}

\item{keywords}{A character vector.}

\item{auth}{A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-custom_emoji: <list>
  |-custom_emoji: <list>
  | |-id: A numeric value
  | |-local_site_id: A numeric value
  | |-shortcode: A character value
  | |-image_url: A character value
  | |-alt_text: A character value
  | |-category: A character value
  | |-published: A character value
  | `-updated: (Optional) A character value
  `-keywords: <list>
    `-[Each element]: <list>
      |-id: A numeric value
      |-custom_emoji_id: A numeric value
      `-keyword: A character value
}
}
\description{
\code{HTTP.POST /custom_emoji}
}
