% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_ban_from_community}
\alias{lemmy_ban_from_community}
\title{Ban a user from a community.}
\usage{
lemmy_ban_from_community(
  community_id,
  person_id,
  ban,
  remove_data = NULL,
  reason = NULL,
  expires = NULL,
  auth,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{community_id}{A numeric value.}

\item{person_id}{A numeric value.}

\item{ban}{A logical value.}

\item{remove_data}{(Optional) A logical value.}

\item{reason}{(Optional) A character value.}

\item{expires}{(Optional) A numeric value.}

\item{auth}{A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 2:
\preformatted{<list>
|-person_view: <list>
| |-person: <list>
| | |-id: A numeric value
| | |-name: A character value
| | |-display_name: (Optional) A character value
| | |-avatar: (Optional) A character value
| | |-banned: A logical value
| | |-published: A character value
| | |-updated: (Optional) A character value
| | |-actor_id: A character value
| | |-bio: (Optional) A character value
| | |-local: A logical value
| | |-banner: (Optional) A character value
| | |-deleted: A logical value
| | |-inbox_url: A character value
| | |-matrix_user_id: (Optional) A character value
| | |-admin: A logical value
| | |-bot_account: A logical value
| | |-ban_expires: (Optional) A character value
| | `-instance_id: A numeric value
| `-counts: <list>
|   |-id: A numeric value
|   |-person_id: A numeric value
|   |-post_count: A numeric value
|   |-post_score: A numeric value
|   |-comment_count: A numeric value
|   `-comment_score: A numeric value
`-banned: A logical value
}
}
\description{
\code{HTTP.POST /community/ban_user}
}
