% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.rgam.R
\name{predict.rgam}
\alias{predict.rgam}
\title{Make predictions from a "rgam" object}
\usage{
\method{predict}{rgam}(object, xnew, ...)
}
\arguments{
\item{object}{Fitted "\code{rgam}" object.}

\item{xnew}{Matrix of new values for \code{x} at which predictions are to
be made.}

\item{...}{Any other arguments to be passed to \code{predict.glmnet()}.}
}
\value{
Predictions of which the model \code{object} makes at
\code{xnew}. The type of predictions depends on whether a \code{type} argument
is passed. By default it givs the linear predictors for the regression model.

If an offset is used in the fit, then one must be supplied via the
\code{newoffset} option.
}
\description{
This function returns the predictions from a "\code{rgam}" object
for a new data matrix.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)
fit <- rgam(x, y)

# predict for full lambda path
predict(fit, xnew = x[1:5, ])

# predict for specific lambda values
predict(fit, xnew = x[1:5, ], s = 0.1)

# predictions for binomial family
bin_y <- ifelse(y > 0, 1, 0)
fit2 <- rgam(x, bin_y, family = "binomial")
# linear predictors
predict(fit2, xnew = x[1:5, ], s = 0.05)
# probabilities
predict(fit2, xnew = x[1:5, ], type = "response", s = 0.05)

}
\seealso{
\code{\link{rgam}}.
}
