% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{inspect}
\alias{inspect}
\title{Inspect Project Data Table Structure}
\usage{
inspect(conn, table_name = NULL)
}
\arguments{
\item{conn}{A DuckDB connection object.}

\item{table_name}{Character string specifying the table name.
If NULL, uses the table name stored in connection attributes.
Default is NULL.}
}
\value{
A data frame containing table information with columns for
column ID, name, type, not null status, default value, and primary key.
}
\description{
Inspects the structure of the project data table showing column information
including name, type, and properties. This is a convenience wrapper
around DBI::dbGetQuery() for examining table schema. Uses the data table name
stored in the connection attributes if available.
}
\examples{
\dontrun{
table_info <- inspect(conn)
}

}
