% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{Recur-class}
\alias{Recur-class}
\title{An S4 Class Representing Formula Response for Recurrent Event Data}
\description{
The class \code{Recur} is an S4 that represents a formula response for
recurrent event data model.  The function \code{\link{Recur}} produces
objects of this class.  See ``Slots'' for details.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{A numeric matrix that consists of the following columns:
\itemize{ \item \code{time1}: the beginning of time segements; \item
\code{time2}: the end of time segements; \item \code{id}: Identificators
of subjects; \item \code{event}: Event indicators; \item:
\code{terminal}: Indicators of terminal events.}}

\item{\code{call}}{A function call producing the object.}

\item{\code{ID}}{A character vector for unique original identificators of subjects.}

\item{\code{ord}}{An integer vector for increasingly ordering data by \code{id},
\code{time2}, and \code{- event}.  Sorting is often done in the
model-fitting steps, where the indices stored in this slot can be used
directly.}

\item{\code{rev_ord}}{An integer vector for reverting the ordering of the sorted
data (by \code{ord}) to its original ordering.  This slot is provided to
easily revert the sorting.}

\item{\code{first_idx}}{An integer vector indicating the first record of each
subject in the sorted matrix.  It helps in the data checking produce and
may be helpful in model-fitting step, such as getting the origin time.}

\item{\code{last_idx}}{An integer vector indicating the last record of each subject
in the sorted data.  Similar to \code{first_idx}, it helps in the data
checking produce and may be helpful in the model-fitting step, such as
locating the terminal events.}

\item{\code{check}}{A character string indicating how the data checking is
performed.  It just records the option that users specified on data
checking.}

\item{\code{time_class}}{A character vector preserving the class(es) of input times.}
}}

\seealso{
\code{\link{Recur}}
}
