% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair.R
\name{pair}
\alias{pair}
\title{Generate all possible pairs}
\usage{
pair(x, y, deduplication = FALSE, add_xy = TRUE)
}
\arguments{
\item{x}{first \code{data.frame}}

\item{y}{second \code{data.frame}. Ignored when \code{deduplication = TRUE}.}

\item{deduplication}{generate pairs from only \code{x}. Ignore \code{y}. This 
is usefull for deduplication of \code{x}.}

\item{add_xy}{add \code{x} and \code{y} as attributes to the returned 
pairs. This makes calling some subsequent operations that need \code{x} and 
\code{y} (such as \code{\link{compare_pairs}} easier.}
}
\value{
A \code{\link[data.table]{data.table}} with two columns, 
\code{.x} and \code{.y}, is returned. Columns \code{.x} and \code{.y} are 
row numbers from \code{data.frame}s \code{.x} and \code{.y} respectively.
}
\description{
Generates all combinations of records from \code{x} and \code{y}.
}
\details{
Generating (all) pairs of the records of two data sets, is usually the first 
step when linking the two data sets.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair(linkexample1, linkexample2)

}
\seealso{
\code{\link{pair_blocking}} and \code{\link{pair_minsim}} are other methods
to generate pairs. The package \pkg{blocking} implements additional methods.
}
