% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R, R/hydrobudget-results.R
\name{write_recharge_rasters}
\alias{write_recharge_rasters}
\alias{write_recharge_rasters.default}
\alias{write_recharge_rasters.hydrobudget}
\title{Write result as raster files}
\usage{
write_recharge_rasters(
  obj,
  water_budget,
  input_rcn,
  crs,
  output_dir = tempdir(),
  ...
)

\method{write_recharge_rasters}{default}(
  obj,
  water_budget,
  input_rcn,
  crs,
  output_dir = tempdir(),
  ...
)

\method{write_recharge_rasters}{hydrobudget}(
  obj,
  water_budget,
  input_rcn,
  crs,
  output_dir = tempdir(),
  ...
)
}
\arguments{
\item{obj}{The recharge object.}

\item{water_budget}{The computed water budget. Input can be a data.frame/data.table or a path to a data file.}

\item{input_rcn}{The RCN values. Input can be a data.frame/data.table or a path to a data file.}

\item{crs}{The coordinate reference systems.}

\item{output_dir}{The output directory where result files will be written. Default is a temporary directory.}

\item{...}{Other arguments passed to methods}
}
\value{
(Invisible) the output directory.
}
\description{
Export raster for interannual runoff, aet and GWR.
}
