% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydrobudget-quality.R
\name{process_river_flow}
\alias{process_river_flow}
\title{River flow processing}
\usage{
process_river_flow(obj, observed_flow, alpha_lyne_hollick)
}
\arguments{
\item{obj}{The HydroBudget object with calibration parameters and column names mappings.}

\item{observed_flow}{The flow rates in mm/day. Input can be a data.frame/data.table or a path to a data file.}

\item{alpha_lyne_hollick}{The Lyne and Hollick filter. Input can be a data.frame/data.table or a path to a data file.}
}
\value{
A list of observed_flow_month and gauging
}
\description{
Processing of the river flow to compute the baseflow with Lyne and Hollick and resample them into monthly observations by:
\enumerate{
\item select the available river flow observations for the simulation period and fill the gaps (up to 5 missing days),
\item extract the list of the available gauging stations for the simulation period (list of the names),
\item compute the Lyne and Hollick baseflow and resample river flow and baseflow with a monthly time step.
}
}
\keyword{internal}
