% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdraws_rpvals.R
\name{plotdiscdensity}
\alias{plotdiscdensity}
\title{Plotting the Density of a Vector of Discrete Values}
\usage{
plotdiscdensity(x, xlab = "value", ylab = "density", ...)
}
\arguments{
\item{x}{The vector of values to plot}

\item{xlab}{The X-axis label for plotting}

\item{ylab}{The Y-axis label for plotting}

\item{...}{Additional plotting arguments}
}
\description{
Plots the empirical density of a vector of discrete values, approximating the probability mass function (pmf).  This can be considered a more appropriate alternative to \code{plot(density(x))} in the case of a vector with a discrete (non-continuous) support, such as that calculated by an abundance estimator.
}
\examples{
draws <- rChapman(length=100000, N=500, n1=100, n2=100)
plotdiscdensity(draws)  #plots the density of a vector of discrete values
}
\author{
Matt Tyers
}
