% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_pvalues_cont.R
\name{pval_cont_fn}
\alias{pval_cont_fn}
\title{Compares observed and expected distribution of p-values for continuous variables}
\usage{
pval_cont_fn(df = pval_cont_data, btsp = 500, title = "", verbose = TRUE)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{btsp}{number of bootstrap repeats used to generate 95\% confidence interval around AUC}

\item{title}{optional title for plots}

\item{verbose}{TRUE or FALSE indicates whether progress bar and comments show and prints plot}
}
\value{
list containing 4 objects as described
\itemize{
\item pval_cont_calculated_pvalues = plots of calculated p-value distribution and AUC
\item pval_cont_reported_pvalues = plots of reported p-value distribution and AUC (if p-values were reported)
\item pval_cont_ft_diff_calc_rep_p = flextable of distribution of differences in calculated and reported results
\item all_results = list containing
\itemize{
\item pval_cont_baseline_pvalues_data = data frame of all results used in calculations
\item pval_cont_diff_calc_rep_p = data frame of differences between calculated and reported p-values
\item pval_cont_reported_pvalues= plot of reported p-value distribution
\item pval_cont_auc_reported_pvalues = AUC of reported p-values
\item pval_cont_calculated_pvalues = plot of calculated p-value distribution
\item pval_cont_auc_calculated_pvalues= AUC of calculated p-values
}}
}
\description{
Creates plots of calculated p-value distribution and AUC (area under curve)\cr
}
\details{
Reference data is from (Carlisle 2017, Bolland 2021)\cr
Carlisle JB . Data fabrication and other reasons for non-random sampling in 5087 randomised, controlled trials in anaesthetic and general medical journals. Anaesthesia 2017;72:944–52 .2017\cr
Bolland MJ, Gamble GD, Grey A, Avenell A. Empirically generated reference proportions for baseline p values from rounded summary statistics. Anaesthesia 2020;75:1685-1687.\cr
See also Bolland MJ, Gamble GD, Avenell A, Grey A, Lumley T. Baseline P value distributions in randomized trials were uniform for continuous but not categorical variables. J Clin Epidemiol 2019;112:67-76.\cr
and Bolland MJ, Gamble GD, Avenell A, Grey A. Rounding, but not randomization method, non-normality, or correlation, affected baseline P-value distributions in randomized trials. J Clin Epidemiol 2019;110:50-62.

Returns a list containing 4 objects and (if verbose = TRUE) prints the plot pval_cont_calculated_pvalues
}
\examples{
# load example data
pval_cont_data <- load_clean(import= "no", file.cont = "SI_pvals_cont", pval_cont= "yes",
format.cont = "wide")$pval_cont_data

\donttest{
# run function (takes only a few seconds)
pval_cont_fn(btsp=100)$pval_cont_calculated_pvalues

# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
pval_cont_data <- load_clean(import= "yes", pval_cont = "yes", dir = path,
     file.name.cont = "reappraised_examples.xlsx", sheet.name.cont = "SI_pvals_cont",
     range.name.cont = "A1:O51", format.cont = "wide")$pval_cont_data}

}
