% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogate_to_analyte_interpolation.R
\name{surrogate_to_analyte_interpolation}
\alias{surrogate_to_analyte_interpolation}
\title{Interpolate timeseries x(tx) onto y(ty)}
\usage{
surrogate_to_analyte_interpolation(tx, x, ty, y, threshold)
}
\arguments{
\item{tx}{time for x "surrogate" (time, POSIXct)}

\item{x}{quantity used to estimate y, for example, accoustic backscatter}

\item{ty}{time for y "analyte" (time, POSIXct)}

\item{y}{measured quantity, for example, an analyte such as suspended-sediment concentration}

\item{threshold}{maximum duration where interpolation is allowed (minutes)}
}
\value{
a data frame with surrogate (x) interpolated onto timestep of analyte (y), interpolated values exceeding threshold are excluded from the output
}
\description{
Interpolate timeseries x(tx) onto y(ty) with temporal threshold on interpolation
}
\examples{
tx <- as.POSIXct(seq(0,24*60^2,60*1), origin = "2000-01-01",tz = "Australia/Brisbane")
x <- sin(1:length(tx))
ty <- as.POSIXct(seq(0,24*60^2,60*15), origin = "2000-01-01",tz = "Australia/Brisbane")
y <- seq(0,24*60^2,60*15)
threshold <- 10
calibration <- surrogate_to_analyte_interpolation(tx,x,ty,y,threshold)
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
