% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_detect}
\alias{re2_detect}
\title{Find the presence of a pattern in string(s)}
\usage{
re2_detect(string, pattern)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}
}
\value{
A logical vector. TRUE if match is found, FALSE if not.
}
\description{
Equivalent to grepl(pattern, x). Vectorized over
  string and pattern. For the equivalent of
  grep(pattern, x) see \code{\link{re2_which}}.
}
\examples{
## Character vector input
s <- c("barbazbla", "foobar", "not present here ")
pat <- "(foo)|(bar)baz"
re2_detect(s, pat)

## Use precompiled regexp
re <- re2_regexp("(foo)|(bAR)baz", case_sensitive = FALSE)
re2_detect(s, re)
}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax, and
  \code{\link{re2_match}} to extract matched groups.
}
