% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{check_classification}
\alias{check_classification}
\title{Validate a classification list.}
\usage{
check_classification(x)
}
\arguments{
\item{x}{list. The classification object loaded via
\code{jsonlite::fromJSON(..., simplifyVector = FALSE)}.}
}
\value{
Logical, \code{TRUE} if valid, otherwise an error is raised.
}
\description{
Ensures the provided JSON-based classification data follows the expected
structure and contains valid fields.
}
\examples{
path <- system.file("extdata", "classification.json", package = "rconvertu")
cls <- jsonlite::fromJSON(path, simplifyVector = FALSE)
check_classification(cls)

}
