% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ttest}
\alias{ttest}
\title{Perform bootstrap or Monte Carlo t-tests on the NRMSE statistic from
the CLSP estimator.}
\usage{
ttest(
  object,
  reset = FALSE,
  sample_size = 50L,
  seed = NULL,
  distribution = NULL,
  partial = FALSE,
  simulate = FALSE
)
}
\arguments{
\item{object}{An object of class \code{"clsp"}.}

\item{reset}{Logical, default = \code{FALSE}.
If \code{TRUE}, forces recomputation of the NRMSE null distribution.}

\item{sample_size}{Integer, default = \code{50}.
Size of the Monte Carlo simulated sample under H0.}

\item{seed}{Integer or \code{NULL}, default = \code{NULL}.
Optional random seed to override the default.}

\item{distribution}{Function or \code{NULL}, default = \code{NULL}.
Distribution for generating synthetic \code{b} vectors. One of:
\code{rnorm}, \code{runif}, or a custom RNG function. Defaults to
standard normal.}

\item{partial}{Logical, default = \code{FALSE}.
If \code{TRUE}, runs the t-test on the partial NRMSE: during simulation,
the C-block entries are preserved and the M-block entries are simulated.}

\item{simulate}{Logical, default = \code{FALSE}.
If \code{TRUE}, performs a parametric Monte Carlo simulation by generating
synthetic right-hand side vectors \code{b}. If \code{FALSE} (default),
executes a nonparametric bootstrap procedure on residuals without
re-estimation.}
}
\value{
A named list containing test results and null distribution statistics:
\describe{
\item{p_one_left}{P(nrmse \eqn{\le} null mean)}
\item{p_one_right}{P(nrmse \eqn{\ge} null mean)}
\item{p_two_sided}{2-sided t-test p-value}
\item{nrmse}{Observed value}
\item{mean_null}{Mean of null distribution}
\item{std_null}{Standard deviation of null distribution}
}
}
\description{
This function either (a) resamples residuals via a nonparametric bootstrap
to generate an empirical NRMSE sample, or (b) produces synthetic right-hand
side vectors \code{b} from a user-defined or default distribution and
re-estimates the model. It tests whether the observed NRMSE significantly
deviates from the null distribution of resampled or simulated NRMSE values.
}
