% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-remapstat.R, R/op-cdo-remapavg.R,
%   R/op-cdo-remapkurt.R, R/op-cdo-remapmax.R, R/op-cdo-remapmean.R,
%   R/op-cdo-remapmedian.R, R/op-cdo-remapmin.R, R/op-cdo-remaprange.R,
%   R/op-cdo-remapskew.R, R/op-cdo-remapstd.R, R/op-cdo-remapstd1.R,
%   R/op-cdo-remapsum.R, R/op-cdo-remapvar.R, R/op-cdo-remapvar1.R
\name{remapstat}
\alias{remapstat}
\alias{cdo_remapavg}
\alias{cdo_remapkurt}
\alias{cdo_remapmax}
\alias{cdo_remapmean}
\alias{cdo_remapmedian}
\alias{cdo_remapmin}
\alias{cdo_remaprange}
\alias{cdo_remapskew}
\alias{cdo_remapstd}
\alias{cdo_remapstd1}
\alias{cdo_remapsum}
\alias{cdo_remapvar}
\alias{cdo_remapvar1}
\title{Remaps source points to target cells}
\usage{
cdo_remapavg(ifile, grid = NULL, ofile = NULL)

cdo_remapkurt(ifile, grid = NULL, ofile = NULL)

cdo_remapmax(ifile, grid = NULL, ofile = NULL)

cdo_remapmean(ifile, grid = NULL, ofile = NULL)

cdo_remapmedian(ifile, grid = NULL, ofile = NULL)

cdo_remapmin(ifile, grid = NULL, ofile = NULL)

cdo_remaprange(ifile, grid = NULL, ofile = NULL)

cdo_remapskew(ifile, grid = NULL, ofile = NULL)

cdo_remapstd(ifile, grid = NULL, ofile = NULL)

cdo_remapstd1(ifile, grid = NULL, ofile = NULL)

cdo_remapsum(ifile, grid = NULL, ofile = NULL)

cdo_remapvar(ifile, grid = NULL, ofile = NULL)

cdo_remapvar1(ifile, grid = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{grid}{STRING - Target grid description file or name}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module maps source points to target cells by calculating a statistical value from the source points. Each target cell contains the statistical value from all source points within that target cell. If there are no source points within a target cell, it gets a missing value. Depending on the chosen operator the minimum, maximum, range, sum, average, variance, standard deviation, skewness, kurtosis or median of source points is computed.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{remapmin     Remap minimum
             Minimum value of the source points.
remapmax     Remap maximum
             Maximum value of the source points.
remaprange   Remap range
             Range (max-min value) of the source points.
remapsum     Remap sum
             Sum of the source points.
remapmean    Remap mean
             Mean of the source points.
remapavg     Remap average
             Average of the source points.
remapstd     Remap standard deviation
             Standard deviation of the source points. Normalize by n.
remapstd1    Remap standard deviation (n-1)
             Standard deviation of the source points. Normalize by (n-1).
remapvar     Remap variance
             Variance of the source points. Normalize by n.
remapvar1    Remap variance (n-1)
             Variance of the source points. Normalize by (n-1).
remapskew    Remap skewness
             Skewness of the source points.
remapkurt    Remap kurtosis
             Kurtosis of the source points.
remapmedian  Remap median
             Median of the source points.
}\if{html}{\out{</div>}}
}
