% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paint_with_mask.R
\name{paint_with_mask}
\alias{paint_with_mask}
\title{Paint with mask}
\usage{
paint_with_mask(r, m, color = "red", where = "outside")
}
\arguments{
\item{r}{\link[terra:SpatRaster-class]{terra::SpatRaster}. The image. Values should be normalized,
see \code{\link[=normalize_minmax]{normalize_minmax()}}. Only images with one or three layers are
supported.}

\item{m}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binary mask with
\code{TRUE} for selected pixels.}

\item{color}{character vector of length one or numeric vector of length
three. Fill color. If character, it is converted to RGB automatically. If
numeric, values must be in range \eqn{[0, 1]}.}

\item{where}{character vector of length one Region to paint relative to \code{m}.
Either \code{"outside"} (default) or \code{"inside"}.}
}
\value{
numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with three layers and the geometry
of \code{r}. Equal to \code{r}, but with pixels in the selected region painted with
\code{color}. Single-layer inputs are replicated to allow color painting.
}
\description{
Paint image pixels inside or outside a logical mask with a solid color.
}
\examples{
\dontrun{
r <- read_caim()
z <- zenith_image(ncol(r), lens())
a <- azimuth_image(z)
m <- select_sky_region(z, 20, 70) & select_sky_region(a, 90, 180)

masked_caim <-  paint_with_mask(normalize_minmax(r), m)
plotRGB(masked_caim * 255)

masked_bin <- paint_with_mask(binarize_with_thr(r$Blue, 125), m)
plotRGB(masked_bin * 255)

r <- normalize_minmax(r)
paint_with_mask(r, m, color = c(0.2, 0.2, 0.2))  # vector
paint_with_mask(r, m, color = "blue")     # name
paint_with_mask(r, m, color = "#00FF00")  # hexadecimal
}
}
