% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-template_mapping.R
\name{transform_point_to_template}
\alias{transform_point_to_template}
\alias{transform_thinfilm_to_mni152}
\title{Calculate template 'MNI' coordinates for points on native brain}
\usage{
transform_point_to_template(
  subject,
  positions,
  space = c("scannerRAS", "tkrRAS"),
  mapping_method = c("volumetric", "surface"),
  flip_hemisphere = FALSE,
  verbose = TRUE,
  project_surface = "pial",
  volumetric_transform = c("auto", "affine", "nonlinear"),
  ...
)

transform_thinfilm_to_mni152(
  subject,
  flip_hemisphere = FALSE,
  interpolator = 0.3,
  n_segments = c(16, 16),
  group_labels = NULL,
  project_surface = "pial",
  volumetric_transform = c("auto", "affine", "nonlinear"),
  template_subject = c("cvs_avg35_inMNI152", "fsaverage", "bert", "MNI152")
)
}
\arguments{
\item{subject}{'RAVE' subject}

\item{positions}{optional matrix of 3 columns, either in scanner or surface
space (specified by \code{space}); default is missing and will use the
electrode localization results (\code{electrodes.csv})}

\item{space}{if \code{positions} is given, which native coordinate system
should be used; default is native 'T1' (or \code{'scannerRAS'}); alternative
is 'FreeSurfer' surface coordinate (or \code{'tkrRAS'})}

\item{mapping_method}{whether the mapping is \code{'volumetric'} or
\code{'surface'}; default is the former.}

\item{flip_hemisphere}{whether to flip the hemisphere; default is
\code{FALSE}}

\item{verbose}{whether to verbose the mapping progress; default is true}

\item{project_surface}{for surface mapping only, which surface to project
electrodes onto; default is \code{'pial'} surface, other common choices
are \code{'white'} for white-matter, or \code{'smoothwm'} for smoothed
white matter}

\item{volumetric_transform}{for volume mapping only, which type of transform
to use; default is \code{'auto'} detecting and use non-linear deformation
if exists, and fall back to 'affine' transform; other choices are
\code{'affine'} or \code{'nonlinear'}}

\item{...}{ignored}

\item{interpolator}{whether the transform lean towards volume mapping
(\code{interpolator=0}) or surface mapping (\code{interpolator=1})}

\item{n_segments}{positive integers with length of two: resolution of the
mapping; default segments the thin-film array into 16 by 16 segments}

\item{group_labels}{\code{NULL} (default) or a character vector indicating
the group labels of thin-film electrodes;
default assumes that all contacts are from thin-film electrodes.}

\item{template_subject}{template subject to be mapped to; default is
\code{'cvs_avg35_inMNI152'}, which is a \code{'MNI152'} template generated
by 'FreeSurfer'; other choices are \code{'fsaverage'} and \code{'bert'}}
}
\value{
A table of electrode 'MNI' coordinates.
}
\description{
Calculate template 'MNI' coordinates for points on native brain
}
\examples{

if(has_rave_subject("demo/DemoSubject")) {

  transform_point_to_template(
    subject = 'demo/DemoSubject',
    mapping_method = "volumetric"
  )

}

}
