% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memo_misc.R
\docType{data}
\name{recipes}
\alias{recipes}
\title{Recipes for Building Container Images}
\format{
An object of class \code{list} of length 5.
}
\usage{
recipes
}
\description{
A list containing several useful recipes for container building. Useful for the \code{post_installation_steps} argument of \code{\link[=dockerize]{dockerize()}}. Available recipes are:
\itemize{
\item \code{texlive}: install pandoc and LaTeX, useful for rendering RMarkdown
\item \code{texlivefull}: Similar to the above, but install the full distribution of TeX Live (~ 3GB)
\item \code{quarto}: install quarto and tinytex
\item \code{clean}: clean up the container image by removing cache
\item \code{make}: install GNU make
}
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                    snapshot_date = "2020-01-16")
    ## install texlive
    dockerize(graph, ".", post_installation_steps = recipes[['texlive']])
}
}
}
\keyword{datasets}
