% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radsub.R
\name{radsub}
\alias{radsub}
\title{Subcategory Analysis Dataset (ADSUB)}
\usage{
radsub(
  adsl,
  param = c("Baseline Weight", "Baseline Height", "Baseline BMI", "Baseline ECOG",
    "Baseline Biomarker Mutation"),
  paramcd = c("BWGHTSI", "BHGHTSI", "BBMISI", "BECOG", "BBMRKR1"),
  seed = NULL,
  na_percentage = 0,
  na_vars = list(),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADSUB data \code{cadsub} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radsub} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Subcategory Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per subject.

Keys: \code{STUDYID}, \code{USUBJID}, \code{PARAMCD}, \code{AVISITN}, \code{ADTM}, \code{SRCSEQ}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adsub <- radsub(adsl, seed = 2)
adsub
}
\author{
tomlinsj, npaszty, Xuefeng Hou, dipietrc
}
