% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radcm.R
\name{radcm}
\alias{radcm}
\title{Previous and Concomitant Medications Analysis Dataset (ADCM)}
\usage{
radcm(
  adsl,
  max_n_cms = 10L,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(CMCLAS = c(NA, 0.1), CMDECOD = c(1234, 0.1), ATIREL = c(1234, 0.1)),
  who_coding = FALSE,
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{max_n_cms}{(\code{integer})\cr Maximum number of concomitant medications per patient. Defaults to 10.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{who_coding}{(\code{flag})\cr Whether WHO coding (with multiple paths per medication) should be used.}

\item{cached}{boolean whether the cached ADCM data \code{cadcm} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radcm} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating random Concomitant Medication Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per each record in the corresponding SDTM domain.

Keys: \code{STUDYID}, \code{USUBJID}, \code{ASTDTM}, \code{CMSEQ}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

adcm <- radcm(adsl, seed = 2)
adcm

adcm_who <- radcm(adsl, seed = 2, who_coding = TRUE)
adcm_who
}
