% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed_functions.R
\name{seed}
\alias{seed}
\alias{gen_seed}
\alias{set_seed}
\alias{fix_seed}
\alias{with_seed}
\alias{pull_seed}
\title{Random Seed Defining Functions}
\usage{
gen_seed()

set_seed(seed)

fix_seed(reset = FALSE)

with_seed(seed, expression)

pull_seed(x)
}
\arguments{
\item{seed}{The random seed to be used}

\item{reset}{Should the fixed seed be forced to reset}

\item{expression}{expression to be evaluated}

\item{x}{object to extract the \code{seed} from}
}
\value{
\code{gen_seed()} returns a single numeric value

\code{with_seed()} returns the value of the evaluated expression after
with the relevant seed as an attribute (if required)

\code{pull_seed()} returns a single numeric value

\code{fix_seed()} and \code{set_seed()} do not return anything
}
\description{
Functions related to generating random seeds and utilising
them for reproducibility.
}
\details{
Random values are generated based on the current seed used by
the R system. This means by deliberately setting a seed in R,
we can make work reproducible.
}
\section{Functions}{
\itemize{
\item \code{gen_seed}: Generates a random seed, which can be used in \code{set_seed()}

\item \code{set_seed}: Sets the current seed

\item \code{fix_seed}: Resets the seed to re-run code

\item \code{with_seed}: Evaluates the expression after setting the seed.
If \code{seed} is \code{TRUE}, then it first generates a seed using
\code{gen_seed()}. Results are output with the \code{seed} attached (if set).#'

\item \code{pull_seed}: Extracts the seed used to generate the results of
\code{with_seed()}
}}

\examples{
my_seed <- gen_seed()


set_seed(my_seed)
r_norm(n=10)
set_seed(my_seed)
r_norm(n=10)


fix_seed()
r_norm(n=3)

fix_seed()
r_norm(n=3)

fix_seed(reset=TRUE)
r_norm(n=3)


res <- with_seed(my_seed, r_norm(n = 10))
res


pull_seed(res)

}
