% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_colley.R
\name{colley}
\alias{colley}
\title{Colley’s Method for Rating and Ranking}
\usage{
colley(jpMat, method = "colley", ties.method = "average")
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying Colley's method, including "colley", "colleym", "colleynt" and "colleymnt"}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\value{
A list of two vectors: a rating vector and a ranking vector
}
\description{
Calculate ratings and provide rankings using Colley’s method
}
\details{
\enumerate{
\item \code{colley}: Colley's method 
\item \code{colleym}: Colleyized Massey method
\item \code{colleynt}: Colley's method, no ties
\item \code{colleymnt}: Colleyized Massey method, no ties
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4), 
nrow=6, 
byrow=TRUE)
result <- colley(jpMat, method='colley')
print(result)
}
\references{
Colley, W. N. (2001). Colley's bias free college football ranking method: the Colley matrix explained.

Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
