% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linesink.R
\name{linesink}
\alias{linesink}
\title{Create a strength-specified line-sink analytic element}
\usage{
linesink(x0, y0, x1, y1, sigma, width = 0, ...)
}
\arguments{
\item{x0}{numeric, starting x location of line-sink.}

\item{y0}{numeric, starting y location of line-sink.}

\item{x1}{numeric, ending x location of line-sink.}

\item{y1}{numeric, ending y location of line-sink.}

\item{sigma}{numeric, specific strength of the line-sink, i.e. discharge per unit length of line-sink. Positive is out of aquifer.}

\item{width}{numeric, width of the line-sink. Only used in \code{\link[=tracelines]{tracelines()}} to determine if a particle has reached the line.
Defaults to zero (infinitesimally narrow line).}

\item{...}{ignored}
}
\value{
Strength-specified line-sink analytic element which is an object of class \code{linesink} and inherits from \code{element}.
}
\description{
\code{\link[=linesink]{linesink()}} creates a line-sink analytic element with constant specified strength.
}
\examples{
ls <- linesink(-75, 50, 100, 50, sigma = 1, width = 3)

}
\seealso{
\code{\link[=headlinesink]{headlinesink()}}
}
