% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfaStep.R
\name{sfaStep}
\alias{sfaStep}
\title{Update a step of the SFA algorithm.}
\usage{
sfaStep(sfaList, arg, step = NULL, method = NULL)
}
\arguments{
\item{sfaList}{A list that contains all information about the handled sfa-structure}

\item{arg}{Input data, each column a different variable}

\item{step}{Specifies the current SFA step.  Must be given in the right sequence: 
  for SFA1 objects:  "preprocessing", "sfa"\cr
  for SFA2 objects:  "preprocessing", "expansion", "sfa"        
    Each time a new step is invoked, the previous one is closed, which
might take some time.}

\item{method}{Method to be used: For \code{sfaList$step="expansion"} the choices are "TIMESERIES" or "CLASSIF". \cr
For \code{sfaList$step="sfa"} (\code{\link{sfa2Step}} only) the choices are "SVDSFA" (recommended) or "GENEIG" (unstable).}
}
\value{
list \code{sfaList} taken from the input, with new information added to this list. 
   See \code{\link{sfa1Step}} or \code{\link{sfa2Step}} for details.
}
\description{
sfaStep() updates the current step of the SFA algorithm. Depending on \code{sfaList$deg}
 it calls either \code{\link{sfa1Step}} or \code{\link{sfa2Step}} to do the main work. 
 See further documentation there
}
\examples{
   ## Suppose you have divided your training data into two chunks,
   ## DATA1 and DATA2. Let the number of input dimensions be N. To apply
   ## SFA on them write:
   \dontrun{ 
   sfaList = sfa2Create(N,xpDim(N))
   sfaList = sfaStep(sfaList, DATA1, "preprocessing")
   sfaList = sfaStep(sfaList, DATA2)
   sfaList = sfaStep(sfaList, DATA1, "expansion")
   sfaList = sfaStep(sfaList, DATA2)
   sfaList = sfaStep(sfaList, NULL, "sfa")
   output1 = sfaExecute(sfaList, DATA1)
   output2 = sfaExecute(sfaList, DATA2)
   }

}
\seealso{
\code{\link{sfa1Step}} \code{\link{sfa2Step}}  \code{\link{sfa1Create}} \code{\link{sfa2Create}} \code{\link{sfaExecute}}
}
