% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nei_coval.R
\name{nei_coval}
\alias{nei_coval}
\title{Calculating neighbor genotypic identity}
\usage{
nei_coval(
  geno,
  smap,
  scale,
  alpha = Inf,
  kernel = c("exp", "gaussian"),
  grouping = rep(1, nrow(smap)),
  n_core = 1L
)
}
\arguments{
\item{geno}{An individual x marker matrix. Bialleles (i.e., A or a) must be converted into -1 or 1 digit.}

\item{smap}{A matrix showing a spatial map for individuals. The first and second column include spatial points along an x-axis and y-axis, respectively.}

\item{scale}{A numeric scalar indicating the maximum spatial distance between a focal individual and neighbors to define neighbor effects.}

\item{alpha}{An option to set a distance decay coefficient \eqn{\alpha} in a dispersal kernel. Default is set at Inf, meaning no distance decay.}

\item{kernel}{An option to select either \code{"exp"} or \code{"gaussian"} for a negative exponential kernel or Gaussian kernel, respectively.}

\item{grouping}{A positive integer vector assigning each individual to a group. This argument can be useful when a "smap" contains different experimental replicates. Default setting means that all individuals are belong to a single group.}

\item{n_core}{No. of cores for a multi-core computation. This does not work for Windows OS. Default is a single-core computation.}
}
\value{
A numeric matrix for neighbor covariates, with no. of individuals x markers.
}
\description{
A function to calculate neighbor genotypic identity, with a given reference scale and a degree of distance decay.
}
\details{
Default setting is recommended for \code{alpha} and \code{kernel} arguments unless spatial distance decay of neighbor effects needs to be modeled.
If \code{alpha} is not \code{Inf}, output variables are weighted by a distance decay from a focal individual to \code{scale}.
For the type of dispersal kernel in the distance decay, we can choose a negative exponential or Gaussian kernel as a fat-tailed or thin-tailed distribution, respectively.
See Nathan et al. (2012) for detailed characteristics of the two dispersal kernels.
}
\examples{
set.seed(1)
g <- matrix(sample(c(-1,1),100*1000,replace = TRUE),100,1000)
gmap <- cbind(c(rep(1,nrow(g)/2),rep(2,nrow(g)/2)),c(1:ncol(g)))
x <- runif(nrow(g),1,100)
y <- runif(nrow(g),1,100)
smap <- cbind(x,y)
grouping <- c(rep(1,nrow(g)/2), rep(2,nrow(g)/2))

g_nei <- nei_coval(g,smap,44,grouping = grouping)
}
\references{
Nathan R, Klein E, Robledo-Arnuncio JJ, Revilla E. (2012) Dispersal kernels: review. In: Clobert J, Baguette M, Benton TG, Bullock JM (Eds.), \emph{Dispersal Ecology and Evolution}. Oxford University Press, pp.186-210.
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
