## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----causal_speed-------------------------------------------------------------
library(rLifting)

if (!requireNamespace("knitr", quietly = TRUE)) {
  knitr::opts_chunk$set(eval = FALSE)
  message("Required package 'knitr' is missing. Vignette code will not run.")
} else {
  library(knitr)
}

data("benchmark_causal", package = "rLifting")

df_causal = data.frame(
  Method = c("rLifting (causal)", "Naive loop (wavethresh)"),
  Time_ms = c(benchmark_causal$rLifting_Time_Avg * 1000,
              benchmark_causal$Wavethresh_Naive_Time * 1000),
  MSE = c(benchmark_causal$rLifting_MSE,
          benchmark_causal$Wavethresh_Naive_MSE)
)

kable(df_causal,
      col.names = c("Method", "Time (ms)", "MSE"),
      digits = 4,
      caption = "Causal denoising: speed and reconstruction accuracy.")

## ----leakage_table------------------------------------------------------------
data("leakage_results", package = "rLifting")

kable(leakage_results,
      col.names = c("Method", "Leakage (SSE)"),
      caption = "Counterfactual leakage: lower is better. Zero means no look-ahead bias.")

