% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criterion.R
\name{bdist}
\alias{bdist}
\title{An rFSA Criterion Function.}
\usage{
bdist(model, name = "B Distance")
}
\arguments{
\item{model}{lm or glm fit to be passed.}

\item{name}{passed to print.FSA}
}
\description{
rFSA Criterion Function to compute the Bhattacharyya distance.
}
\examples{
#To use Bhattacharyya Distance and FSA the response must be binary, and you must
#be considering searching for two way continuous interactions. 
data(mtcars)
fit<-FSA(formula = "am~gear*hp",data = mtcars,
fitfunc = glm,family="binomial",m = 2,cores=1,
interactions = TRUE,criterion = bdist,minmax = "max")
}
