% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rAccess}
\alias{rAccess}
\title{rAccess module functions - R6 object}
\description{
The \code{rAccess} class encapsulates various methods used in the IAM (Identity
and Access Management) module.
It provides functionalities to check user permissions, verify admin status,
retrieve user details,
and interact with pin boards for access control configuration.
}
\section{Fields}{

\describe{
\item{\code{user}}{User ID}
\item{\code{app_name}}{Application Name}
\item{\code{pin_name}}{Pin name}
\item{\code{pin_list}}{List of pins}
\item{\code{pin_board}}{Pin board object}
\item{\code{access_panels}}{Available access panels}
\item{\code{access_units}}{Available access units}
\item{\code{access_mode}}{Access mode, e.g., "default", "single unit"}
\item{\code{user_df}}{Data frame of user IDs and names}
\item{\code{switch_size}}{Size of UI switch elements
(e.g., "small", "large", "default", "mini", "small", "normal", "large")}
\item{\code{unit_display}}{Display type for access units
("switch", "dropdown")}
\item{\code{board_type}}{Type of pin board ("local", "s3", "rconnect")}
\item{\code{local_board_path}}{Local path for local pin boards}
\item{\code{s3_bucket}}{S3 bucket name}
\item{\code{s3_access_key}}{S3 access key}
\item{\code{s3_secret_key}}{S3 secret key}
\item{\code{use_rconnect_users}}{Boolean, use rconnect users in
conjunction with user_df}
\item{\code{config}}{Configuration file content}
\item{\code{data}}{List of data paths from config}
\item{\code{verbose}}{Boolean, whether to print logs}
\item{\code{panel_config}}{Complete panel structure}
\item{\code{secure_mode}}{Boolean, enforce access requirement}
}
}

\section{Methods}{

\describe{
\item{\code{initialize(user, ...)}}{Constructor to create an instance with
specified parameters.}
\item{\code{check_access(user_id, access_panel)}}{Checks user access rights
for a given panel.}
\item{\code{is_admin()}}{Checks if the current user is an admin.}
\item{\code{no_admin()}}{Checks if there are no admins in the admin panel.}
\item{\code{get_userlist_unit(access_panel, access_unit)}}{Gets list of
users with access to the specified unit.}
\item{\code{rAccessThemes()}}{Includes custom CSS themes for the app.}
\item{\code{get_user_accesslist(user_id)}}{Lists access units available to
a user, including "everyone".}
\item{\code{get_superAdmins()}}{Returns list of admin user IDs.}
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{user}}{User ID}

\item{\code{app_name}}{App Name}

\item{\code{pin_name}}{A field that takes the argument pin_name}

\item{\code{pin_list}}{A field that takes the argument pin_list}

\item{\code{pin_board}}{A field that takes the argument pin_board}

\item{\code{access_panels}}{A field that takes the argument access_panels}

\item{\code{access_units}}{A field that takes the argument access_units}

\item{\code{access_mode}}{Enables user to select access modes.Available access
modes are :
default - Allows access to multiple access panels and multiple access
units, single unit - Allows access to single access unit within an
access panel.}

\item{\code{user_df}}{A data.frame with user id and user name}

\item{\code{switch_size}}{Takes values : 'default', 'mini', 'small', 'normal',
'large'. Determines the size of access unit switches used in the module.}

\item{\code{unit_display}}{Takes values : 'switch', 'dropdown'. Determines
the type of display for access units. Defaults to 'switch'.}

\item{\code{board_type}}{Board type. Takes values "local", "s3", "rconnect"}

\item{\code{local_board_path}}{Local board path.}

\item{\code{s3_bucket}}{S3 bucket}

\item{\code{s3_access_key}}{S3 Access Key}

\item{\code{s3_secret_key}}{S3 Secret Key}

\item{\code{use_rconnect_users}}{If true then rconnect users will be combined
with the given user_df}

\item{\code{config}}{rAccess configuration file}

\item{\code{data}}{Lists all datapaths in config file}

\item{\code{verbose}}{If TRUE, prints all data base updates in the log}

\item{\code{panel_config}}{A list with entire panel structure including
datapaths}

\item{\code{secure_mode}}{If TRUE, then user should have access to at least one
access_unit/access_panel to use the app.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rAccess-new}{\code{rAccess$new()}}
\item \href{#method-rAccess-matched_users}{\code{rAccess$matched_users()}}
\item \href{#method-rAccess-check_access}{\code{rAccess$check_access()}}
\item \href{#method-rAccess-is_admin}{\code{rAccess$is_admin()}}
\item \href{#method-rAccess-no_admin}{\code{rAccess$no_admin()}}
\item \href{#method-rAccess-get_userlist_unit}{\code{rAccess$get_userlist_unit()}}
\item \href{#method-rAccess-rAccessThemes}{\code{rAccess$rAccessThemes()}}
\item \href{#method-rAccess-get_user_accesslist}{\code{rAccess$get_user_accesslist()}}
\item \href{#method-rAccess-get_superAdmins}{\code{rAccess$get_superAdmins()}}
\item \href{#method-rAccess-clone}{\code{rAccess$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-new"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-new}{}}}
\subsection{Method \code{new()}}{
Constructor to initialize an rAccess object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$new(
  user = NULL,
  pin_board = NULL,
  app_name = NULL,
  pin_name = NULL,
  access_panels,
  access_units = NULL,
  access_mode = "default",
  user_df = NULL,
  switch_size = NULL,
  unit_display = "switch",
  board_type = NULL,
  local_board_path = NULL,
  s3_bucket = NULL,
  s3_access_key = NULL,
  s3_secret_key = NULL,
  use_rconnect_users = TRUE,
  config = NULL,
  verbose = FALSE,
  secure_mode = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{User ID}

\item{\code{pin_board}}{Pin board}

\item{\code{app_name}}{App name}

\item{\code{pin_name}}{Pin name}

\item{\code{access_panels}}{Access panels}

\item{\code{access_units}}{Access units}

\item{\code{access_mode}}{Access mode}

\item{\code{user_df}}{Data Frame with username and userid}

\item{\code{switch_size}}{Determines size of access unit switches : \code{default},
\code{mini}, \code{small}, \code{normal}, \code{large}}

\item{\code{unit_display}}{Determines the type of display for access units :
\code{switch}, \code{dropdown}.}

\item{\code{board_type}}{Pin board type: \code{local}, \code{s3}, \code{rconnect}}

\item{\code{local_board_path}}{Local path to save pin_board when board_type is
\code{local}.}

\item{\code{s3_bucket}}{S3 bucket id}

\item{\code{s3_access_key}}{Access key to S3 bucket}

\item{\code{s3_secret_key}}{Secret Key to S3 bucket}

\item{\code{use_rconnect_users}}{If TRUE, then rconnect users will be combined
with user_df when deployed.}

\item{\code{config}}{rAccess configuration file}

\item{\code{verbose}}{If TRUE, prints all data base updates in the log}

\item{\code{secure_mode}}{If TRUE, then user should have access to at least one
access_unit/access_panel to use the app.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
pin_name, access_panels, access_units, Pin_board ...
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-matched_users"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-matched_users}{}}}
\subsection{Method \code{matched_users()}}{
Find users matching search input in self$user_df
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$matched_users(contact_info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contact_info}}{User entered search text}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-check_access"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-check_access}{}}}
\subsection{Method \code{check_access()}}{
To check user access rights to an access unit within a
particular access panel. Returns access details from the app's access
pin board that matches given user_id and access panel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$check_access(user_id = self$user, access_panel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_id}}{User ID}

\item{\code{access_panel}}{Access Panel name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-is_admin"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-is_admin}{}}}
\subsection{Method \code{is_admin()}}{
To check if the user is Admin in order to provide access to
IAM module. Returns TRUE if it is an admin user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$is_admin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-no_admin"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-no_admin}{}}}
\subsection{Method \code{no_admin()}}{
check if there is no user in the ADMIN panel
Returns FALSE if there is one or more admins.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$no_admin()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-get_userlist_unit"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-get_userlist_unit}{}}}
\subsection{Method \code{get_userlist_unit()}}{
Gets user list filtered by given access unit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$get_userlist_unit(access_panel, access_unit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{access_panel}}{Access panel name}

\item{\code{access_unit}}{Access unit name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-rAccessThemes"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-rAccessThemes}{}}}
\subsection{Method \code{rAccessThemes()}}{
Function to inline js/css into the main app’s HTML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$rAccessThemes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-get_user_accesslist"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-get_user_accesslist}{}}}
\subsection{Method \code{get_user_accesslist()}}{
Function to get list of access units for a given user.
Note that it will contain access units that are accessible by \code{everyone}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$get_user_accesslist(user_id = self$user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_id}}{User ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-get_superAdmins"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-get_superAdmins}{}}}
\subsection{Method \code{get_superAdmins()}}{
Function to get app admins
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$get_superAdmins()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
ADMIN user ids
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAccess-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rAccess-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rAccess$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
