% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{summaryFits}
\alias{summaryFits}
\title{summaryFits: Fit Summary}
\usage{
summaryFits(fdo, lmFit = TRUE, curvTest = TRUE)
}
\arguments{
\item{fdo}{An object of class \code{\link{facDesign.c}}.}

\item{lmFit}{A logical value deciding whether the fits from the object \code{fdo} should be included or not. By default, \code{lmFit} is set to \code{TRUE}.}

\item{curvTest}{A logical value deciding whether curvature tests should be performed or not. By default, \code{curvTest} is set to \code{TRUE}.}
}
\value{
A summary output of the fitted linear models, which may include the linear fits, curvature tests, and original fit values, depending on the input parameters.
}
\description{
Function to provide an overview of fitted linear models for objects of class \code{\link{facDesign.c}}.
}
\examples{
dfac <- facDesign(k = 3)
dfac$.response(data.frame(y = rnorm(8), y2 = rnorm(8)))
dfac$set.fits(lm(y ~ A + B , data = dfac$as.data.frame()))
dfac$set.fits(lm(y2 ~ A + C, data = dfac$as.data.frame()))
summaryFits(dfac)
}
