% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSI.R
\name{DSI}
\alias{DSI}
\title{Calculate the Disease Severity Index (DSI) (class for each unit)}
\usage{
DSI(unit, class, max)
}
\arguments{
\item{unit}{A vector representing the units.}

\item{class}{A vector representing the classes corresponding to the units.}

\item{max}{A numeric value representing the maximum possible class value.}
}
\value{
Returns a single numeric value representing the DSI.
}
\description{
This function calculates the Disease Severity Index (DSI) based on the provided unit,
class, and maximum class value. The DSI is computed by aggregating the classes,
calculating weights by multiplying the frequency of each class by the class itself,
and then dividing the sum of these weights by the product of the total number of
entries and the maximum class value, then multiplying by 100.
}
\examples{
# Example usage:
unit <- c(1, 2, 3, 4, 5, 6)
class <- c(1, 2, 1, 2, 3, 1)
max <- 3
DSI(unit, class, max)

}
\seealso{
Other Disease quantification: 
\code{\link{CompMuCens}()},
\code{\link{DSI2}()}
}
\concept{Disease quantification}
