% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSlines.R
\name{segments3js}
\alias{segments3js}
\title{Add lines segments a 3js object}
\usage{
segments3js(
  data3js,
  x,
  y,
  z,
  lwd = 1,
  col = "black",
  highlight,
  geometry = FALSE,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{x coords}

\item{y}{y coords}

\item{z}{z coords}

\item{lwd}{line width}

\item{col}{line color}

\item{highlight}{highlight characteristics (see \code{highlight3ks()})}

\item{geometry}{logical, should the lines be rendered as a physical geometries}

\item{...}{further parameters to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Add lines segments a 3js object
}
\examples{
# Draw three lines
x <- seq(from = 0, to = 6, length.out = 100)
y <- cos(x*5)
z <- sin(x*5)
linecols <- rainbow(100)

p <- plot3js(
  xlim = c(0, 6),
  ylim = c(0, 6),
  zlim = c(-1, 1),
  aspect = c(1, 1, 1),
  label_axes = FALSE
)

# Add a line using the linegl representation
p <- segments3js(
  data3js = p,
  x, y + 1, z,
  col = linecols
)

# Add a thicker line using the linegl representation
p <- segments3js(
  data3js = p,
  x, y + 3, z,
  lwd = 3,
  col = linecols
)

# Add a line as a physical geometry to the plot
p <- segments3js(
  data3js = p,
  x, y + 5, z,
  lwd = 0.2,
  geometry = TRUE,
  col = "blue" # Currently only supports fixed colors
)

# View the plot
r3js(p, rotation = c(0, 0, 0), zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
