% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_style}
\alias{m_add_style}
\title{Overwrite Previous Style}
\usage{
m_add_style(id, style = m_style_cartoon(), sel = m_sel())
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{style}{Style spec to apply to specified atoms using m_style_*()}

\item{sel}{Atom selection specification with \code{m_sel()}}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Takes a selection and overwrites previous styling with given styles.
}
\examples{
library(r3dmol)

# Add style to model
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_add_style(style = m_style_cartoon()) \%>\%
  m_zoom_to()

# Set style to model
r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_set_style(style = m_style_cartoon()) \%>\%
  m_set_style(
    sel = m_sel(chain = "A"),
    style = m_style_stick(
      radius = 0.5,
      colorScheme = "magentaCarbon"
    )
  ) \%>\%
  m_zoom_to()
}
