% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_latex.R
\name{to_latex}
\alias{to_latex}
\alias{to_latex.SPSS_table}
\alias{to_latex.data.frame}
\title{Print LaTeX Tables that Mimic the Look of SPSS Output}
\usage{
to_latex(object, ...)

\method{to_latex}{SPSS_table}(object, version = r2spss_options$get("version"), ...)

\method{to_latex}{data.frame}(
  object,
  main = NULL,
  sub = NULL,
  header = TRUE,
  label = NULL,
  row_names = TRUE,
  info = NULL,
  alignment = NULL,
  border = NULL,
  footnotes = NULL,
  major = NULL,
  minor = NULL,
  version = r2spss_options$get("version"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"SPSS_table"} as returned by
\code{to_SPSS} methods, or a \code{data.frame}.}

\item{\dots}{for the \code{"data.frame"} method, additional arguments to be
passed to \code{\link{format_SPSS}}.  For the \code{"SPSS_table"} method,
additional arguments are currently ignored.}

\item{version}{a character string specifying whether the table should
mimic the look of recent SPSS versions (\code{"modern"}) or older versions
(<24; \code{"legacy"}).  For the \code{"SPSS_table"} method, note that also
the \emph{content} of some tables generated by functions in \pkg{r2spss} is
different for current and older SPSS versions.  These objects contain a
component \code{"version"} which will passed to the \code{"data.frame"}
method to ensure that the content and look of the table match.  Other
tables have the same content irrespective of the SPSS version, and this
argument controls the look of those tables.  The default is to inherit
from the global option within the current \R session (see
\code{\link{r2spss_options}}).}

\item{main}{a single character string defining the main title of the SPSS
table, or \code{NULL} to suppress the main title.}

\item{sub}{a single character string defining the sub-title of the SPSS
table, or \code{NULL} to suppress the sub-title.}

\item{header}{a logical indicating whether to include a header in the SPSS
table based on the column names of \code{object} (defaults to \code{TRUE}).
Alternatively, it is possible to supply a character vector giving the
header of each column, or a list defining a complex header layout with
merged header cells.  In the latter case, the list can have up to three
components, with each component defining one level of the header.  The last
list component should be a character vector giving the bottom-level header
of each column.  The other list components should be data frames with the
following columns:
\describe{
  \item{\code{first}}{an integer vecot giving the first column of each
  (merged) header cell.}
  \item{\code{last}}{an integer vector giving the last column of each
  (merged) header cell.}
  \item{\code{text}}{a character vector containing the text of each (merged)
  header cell.}
}
Line breaks (character \code{\\n}) can be included to wrap the text of a
header cell over several rows.}

\item{label}{a character string giving a label to be added as the first
column of the table, or \code{NULL} to suppress such a column.  In many
SPSS tables, this contains the name of a variable used in the analysis.}

\item{row_names}{a logical indicating whether to add the row names of
\code{object} as a column in the SPSS table (defaults to \code{TRUE}).
Alternatively, it is possible to supply a character vector giving the
row labels to be added as a column.  Line breaks (character \code{\\n}) can
be included to wrap the text of a row label over several rows.}

\item{info}{an integer giving the number of columns in the SPSS table
that contain auxiliary information on the results.  This has an effect
of the default formatting, alignment, and borders.  The default is 0 if
\code{row_names} is \code{FALSE} and 1 otherwise.  Note that a column
defined by \code{label} and a column defined by \code{row_names} are
always added to \code{info} if the former are supplied.}

\item{alignment}{a list with components \code{header} and \code{table},
with each component being a character vector that contains the LaTeX
alignment specifiers of the header and table body, respectively, of each
column.  Permissible alignment specifiers are \code{"l"} for left-aligned,
\code{"c"} for centered, and \code{"r"} for right aligned.  The default is
left-aligned for the header and table body of the columns containing
auxiliary information, and centered and right-aligned, respectively, for the
header and table body of the columns containing the actual results.  It
should not be necessary to set the column alignment manually.}

\item{border}{a logical vector indicating which (outer and inner) vertical
borders should be drawn.  The default is that tables that mimic recent
versions of SPSS (\code{version = "modern"}) draw only borders in between
columns that contain the actual results, whereas tables that mimic older
versions of SPSS (\code{version = "legacy"}) draw all borders except in
between columns containing auxiliary information.  It should not be
necessary to set the vertical borders manually.}

\item{footnotes}{a character vector giving footnotes to be added below the
SPSS table, or \code{NULL} to suppress footnotes.  Alternatively, it is
possible to supply a data frame with the following columns:
\describe{
  \item{\code{marker}}{character vector giving footnote markers to be
  included in a cell of the SPSS table.  For footnotes without a marker,
  an empty character string can be used.}
  \item{\code{row}}{an integer vector specifying the row of the SPSS table
  in which to include each footnote marker, or \code{NA} for footnotes
  without a marker.  In addition, the character strings \code{"main"} and
  \code{"sub"} can be used to include footnote markers in the main title
  and sub-title, respectively.}
  \item{\code{column}}{an integer vector specifying the column of the SPSS
  table in which to include each footnote marker, or \code{NA} for footnotes
  without a marker or footnote markers in the main title or sub-title.}
  \item{\code{text}}{a character vector containing the text of each
  footnote.}
}}

\item{major, minor}{an integer vector specifying the rows of the SPSS
table after which to draw major or minor grid lines that stretch across
all columns of the table, or \code{NULL} to suppress the respective grid
lines.  Alternatively, each of these arguments can be a data frame with
the following columns defining partial grid lines:
\describe{
  \item{\code{row}}{an integer vector specifying the rows of the SPSS table
  after which to draw grid lines.}
  \item{\code{first}}{an integer vector specifying the first column of each
  partial line.}
  \item{\code{last}}{an integer vector specifying the last column of each
  partial line.}
}
The only difference between the two type of grid lines is that minor grid
lines can also be suppressed globally within the current \R session by
setting \code{r2spss_options$set(minor = FALSE)}, see
\code{\link{r2spss_options}}.  Also note that these arguments only control
the grid lines in between rows of the table body.  Horizontal table borders
are always drawn.}
}
\value{
Nothing is returned, the function is called for its side effects.
}
\description{
Use information from an \R object to print a LaTeX table that mimics the
look of SPSS output.  Typically, one would first call \code{\link{to_SPSS}}
with an object returned by a function in \pkg{r2spss}, and then call
\code{to_latex} with the resulting object of class \code{"SPSS_table"} to
print the LaTeX table.  Note that the \code{print} methods in \pkg{r2spss}
perform these two steps at once, but calling \code{\link{to_SPSS}} and
\code{to_latex} separately can be useful for customization of the LaTeX
table.
}
\details{
The \code{"SPSS_table"} method takes component \code{table} of the object
and supplies it to the \code{data.frame} method, with additional components
in the object being passed as additional arguments.

The \code{"data.frame"} method allows to extend the functionality of
\pkg{r2spss} with additional LaTeX tables that mimic the look of SPSS
output.
}
\note{
LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
## Kruskal-Wallis test example

# load data
data("Eredivisie")

# compute a Kruskual-Wallis test to investigate whether
# market values differ by playing position
kw <- kruskal_test(Eredivisie, "MarketValue",
                   group = "Position")

# convert to an object of class "SPSS_table" that
# contains the table with the test results
kw_spss <- to_SPSS(kw, statistics = "test")
kw_spss

# blank out the number of degrees of freedom to ask
# an assignment question about it
kw_spss$table[2, 1] <- "???"

# print the LaTeX table to be included in the assignment
to_latex(kw_spss)


## t test example

# load data
data("Exams")

# test whether the average grade on the resit
# differs from 5.5 (minimum passing grade)
t <- t_test(Exams, "Resit", mu = 5.5)

# convert to an object of class "SPSS_table" that
# contains the table with the test results
t_spss <- to_SPSS(t, statistics = "test")

# this is an example of a complex header layout
t_spss$header

# add additional line breaks in bottom-level header
t_spss$header[[3]] <- gsub("-", "-\n", t_spss$header[[3]],
                           fixed = TRUE)

# print the LaTeX table
to_latex(t_spss)

}
\author{
Andreas Alfons
}
\keyword{print}
