% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qroc.R
\name{qroc-qprc}
\alias{qroc-qprc}
\alias{qroc}
\alias{qroc.default}
\alias{qroc.qwraps2_confusion_matrix}
\alias{qroc.glm}
\alias{qprc}
\alias{qprc.default}
\alias{qprc.qwraps2_confusion_matrix}
\alias{qprc.glm}
\title{Receiver-Operator and Precision-Recall Curves}
\usage{
qroc(x, ...)

\method{qroc}{default}(x, ...)

\method{qroc}{qwraps2_confusion_matrix}(x, ...)

\method{qroc}{glm}(x, ...)

qprc(x, ...)

\method{qprc}{default}(x, ...)

\method{qprc}{qwraps2_confusion_matrix}(x, ...)

\method{qprc}{glm}(x, ...)
}
\arguments{
\item{x}{an object}

\item{...}{pass through}
}
\value{
a ggplot.  Minimal aesthetics have been used so that the user may
modify the graphic as desired with ease.
}
\description{
Construction of ROC and PRC data and plots.
}
\details{
The area under the curve (AUC) is determined by a trapezoid approximation for
both the AUROC and AUPRC.

More details and examples for graphics within qwraps2 are in the
vignette(\dQuote{qwraps2-graphics}, package = \dQuote{qwraps2})
}
\examples{
#########################################################
# Example 1

df <-
  data.frame(
      truth = c(1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0)
    , pred  = c(1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0)
  )

cm <- confusion_matrix(df$truth, df$pred)
qroc(cm)
qprc(cm)

#########################################################
# Getting a ROC or PRC plot from a glm object:

mod <- glm(
  formula = spam ~ word_freq_our + word_freq_over + capital_run_length_total
, data = spambase
, family = binomial()
)

qroc(mod)
qprc(mod)

#########################################################
# View the vignette for more examples
\dontrun{
vignette("qwraps2-graphics")
}

}
