% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_elo.R
\name{m_elo}
\alias{m_elo}
\title{randompair}
\usage{
m_elo(
  df_pw,
  wl,
  elo_randomisations = 500,
  initial_rating = 0,
  k = 100,
  cores = 1
)
}
\arguments{
\item{df_pw}{dataframe, indicating a dataframe that includes the columns of
winners and losers.}

\item{wl}{vector, indicating the column names of winners and losers (c('w', 'l')).
The first column name is for winners and the second column name is for losers.}

\item{elo_randomisations}{numeric, indicating the number of interactions that
the Elo rating system is run with the randomized pairwise comparisons}

\item{initial_rating}{The initial rating of the players at the beginning}

\item{k}{numeric, the K-factor determines the amount of change to the updated ratings}

\item{cores}{numeric, indicating the number of CUP cores to be used for parallel
processing}
}
\value{
dataframe
}
\description{
ramdonly pair players using reservoir sampling method.
}
\examples{
df <- data.frame(a = c(1,6,0,4,'a','v',9,'n'), b = c('w',3,5,2,'d','j',8,'p'))
pw <- quickPWCR::m_elo(df_pw = df, 
                       wl = c('a', 'b'), 
                       elo_randomisations = 100, 
                       initial_rating = 1000, 
                       k = 100, 
                       cores = 1)

}
\references{
Glickman, M. E., & Jones, A. C. (1999). Rating the chess rating system.
CHANCE-BERLIN THEN NEW YORK-, 12, 21-28.
}
