% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{revalids}
\alias{revalids}
\title{Recode Invalid Values from Data}
\usage{
revalids(data, vrb.nm, valid, undefined = NA, suffix = "_v")
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{valid}{atomic vector of valid values for the data. Note, the valid
values must be the same for each variable.}

\item{undefined}{atomic vector of length 1 specifying what the invalid values
should be recoded to.}

\item{suffix}{character vector of length 1 specifying the string to add to
the end of the colnames in the return object.}
}
\value{
data.frame of recoded variables where any values not present in
  \code{valid} have been recoded to \code{undefined} with colnames specified
  by \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{revalids} recodes invalid data to specified values. For example,
sometimes invalid values are present in a vector of data (e.g., age = -1).
This function allows you to specify which values are possible and will then
recode any impossible values to \code{undefined}. \code{revalids} is simply a
vectorized version of \code{revalid} to more easily revalid multiple columns
of a data.frame at the same time.
}
\examples{
revalids(data = attitude, vrb.nm = names(attitude),
   valid = 25:75) # numeric data
revalids(data = as.data.frame(CO2), vrb.nm = c("Type","Treatment"),
   valid = c('Quebec','nonchilled')) # factors
}
\seealso{
\code{\link{revalid}}
   \code{\link{valids_test}}
   \code{\link{valid_test}}
}
