% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_uniprot_data.R
\name{build_query_url}
\alias{build_query_url}
\title{Accessory function used to build the query url}
\usage{
build_query_url(
  query = NULL,
  base_url = "https://rest.uniprot.org/uniprotkb/",
  columns = c("accession", "id", "gene_names", "organism_name", "reviewed"),
  format = "json"
)
}
\arguments{
\item{query}{list of keys corresponding to UniProt's query fields.
For example :
list("gene_exact" = c("Pik3r1", "Pik3r2") ,
"organism" = c("10090", "9606"), "reviewed" = "yes")}

\item{base_url}{The base url for the UniProt REST API}

\item{columns}{names of UniProt data columns to retrieve.}

\item{format}{format of the response provided by the UniProt API}
}
\value{
the query url
}
\description{
Accessory function used to build the query url
}
