% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{kernels}
\alias{kernels}
\alias{W0}
\alias{W1}
\alias{W2}
\alias{W3}
\alias{WDaniell}
\alias{WParzen}
\title{Kernel function.}
\usage{
W0(x)

W1(x)

W2(x)

W3(x)

WDaniell(x, a = (pi/2))

WParzen(u)
}
\arguments{
\item{x}{real-valued argument to the function; can be a vector}

\item{a}{real number between 0 and \eqn{\pi}{pi}}

\item{u}{real number}
}
\description{
Implementations of kernel functions
}
\details{
Daniell kernel function \code{W0}:
\deqn{\frac{1}{2\pi} I\{|x| \leq \pi\}.}{1/(2pi) I{|x|<=pi}.}

Epanechnikov kernel \code{W1} (i. e., variance minimizing kernel function of order 2):
\deqn{\frac{3}{4\pi} (1-\frac{x}{\pi})^2 I\{|x| \leq \pi\}.}{3/(4pi) (1-x/pi)^2 I{|x|<=pi}.}

Variance minimizing kernel function \code{W2} of order 4:
\deqn{\frac{15}{32\pi} (7(x/\pi)^4 -10(x/\pi)^2+3) I\{|x| \leq \pi\}.}{(15/(32 pi) (7 (x/pi)^4 - 10 (x/pi)^2 + 3) I{|x|<=pi}.}

Variance minimizing kernel function \code{W3} of order 6:
\deqn{\frac{35}{256\pi} (-99(x/\pi)^6 + 189(x/\pi)^4 - 105(x/\pi)^2+15) I\{|x| \leq \pi\}.}{(35/(256 pi) (-99(x/pi)^6 + 189(x/pi)^4 - 105(x/pi)^2+15) I{|x|<=pi}.}

Kernel yield by convolution of two Daniell kernels:
\deqn{\frac{1}{\pi+a} \Big(1-\frac{|x|-a}{\pi-a} I\{a \leq |x| \leq \pi\}\Big).}

Parzen Window for lagEstimators
}
\examples{
plot(x=seq(-8,8,0.05), y=W0(seq(-8,8,0.05)), type="l")
plot(x=seq(-8,8,0.05), y=W1(seq(-8,8,0.05)), type="l")
plot(x=seq(-8,8,0.05), y=W2(seq(-8,8,0.05)), type="l")
plot(x=seq(-8,8,0.05), y=W3(seq(-8,8,0.05)), type="l")
plot(x=seq(-pi,pi,0.05), y=WDaniell(seq(-pi,pi,0.05),a=(pi/2)), type="l")
plot(x=seq(-2,2,0.05),y=WParzen(seq(-2,2,0.05)),type = "l")
}
