% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.quadVAR}
\alias{predict.quadVAR}
\title{Predict the values of the dependent variables using the quadVAR model}
\usage{
\method{predict}{quadVAR}(
  object,
  newdata = NULL,
  donotpredict = NULL,
  lowerbound = -Inf,
  upperbound = Inf,
  with_const = FALSE,
  ...
)
}
\arguments{
\item{object}{A quadVAR object.}

\item{newdata}{A data frame or tibble containing at least the values of the independent variables, dayvar, and beepvar (if used in model estimation). If NULL, the original data used to fit the model will be used.}

\item{donotpredict}{NOT IMPLEMENTED YET! A character vector of the model names that are not used for prediction. Possible options include "AR", "VAR", "VAR_full", "quadVAR_full", "all_others", with NULL as the default. If set "all_others", then only a \code{quadVAR} model will be estimated. For datasets with large number of variables, you may set this parameter to "quadVAR_full" to save time.}

\item{lowerbound}{A numeric value or a vector with the same length as the number of variables that specifies the lower bound of the predicted values. If the predicted value is less than this value, it will be replaced by this value. The default value is -Inf.}

\item{upperbound}{A numeric value or a vector with the same length as the number of variables that specifies  the upper bound of the predicted values. If the predicted value is greater than this value, it will be replaced by this value. The default value is Inf.}

\item{with_const}{A logical value indicating whether to include the constant variables in the prediction. Those variables were automatically excluded in the estimation procedure. The default value is FALSE. When set to TRUE, the lowerbound and upperbound should be a vector with the same length as the number of variables in the model, including the constant variables. The values of the constant variables will be ignored though because their predicted values are always the same, which is the constant value in the input data.}

\item{...}{Other arguments passed to the \code{\link[RAMP:predict.RAMP]{RAMP::predict.RAMP()}} function.}
}
\value{
A data frame or tibble containing the predicted values of the dependent variables. If a value cannot be predicted (e.g., because the corresponding previous time point is not in the data), it will be NA.
}
\description{
Predict the values of the dependent variables using the quadVAR model
}
