% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_samplers_univariate.R
\name{slice_elliptical}
\alias{slice_elliptical}
\title{Univariate Elliptical Slice Sampler}
\usage{
slice_elliptical(x, log_target, mu, sigma)
}
\arguments{
\item{x}{The current state (as a numeric scalar).}

\item{log_target}{A function taking numeric scalar that evaluates the
(potentially unnormalized) log-target density, returning a numeric scalar.}

\item{mu}{A numeric scalar with the mean of the supporting normal distribution.}

\item{sigma}{A numeric scalar with the standard deviation of the supporting normal distribution.}
}
\value{
A list with two elements:

\code{x} is the new state.

\code{nEvaluations} is the number of evaluations of the target function used to obtain the new
state.
}
\description{
Algorithm 1 of Nishihara et al. (2014) of the
elliptical slice sampler of Murray et al. (2010).
}
\examples{
lf <- function(x) dbeta(x, 3, 4, log = TRUE)
draws <- numeric(10) # set to numeric(1e3) for more complete illustration
nEvaluations <- 0L
for (i in seq.int(2, length(draws))) {
  out <- slice_elliptical(draws[i - 1], log_target = lf, mu = 0.5, sigma = 1)
  draws[i] <- out$x
  nEvaluations <- nEvaluations + out$nEvaluations
}
nEvaluations / (length(draws) - 1)
plot(density(draws), xlim = c(0, 1))
curve(exp(lf(x)), 0, 1, col = "blue", add = TRUE)

}
\references{
Murray, I., Adams, R., and MacKay, D., (2010), "Elliptical Slice Sampling," in \emph{Proceedings of the Thirteenth International Conference on Artificial Intelligence and Statistics}, JMLR Workshop and Conference Proceedings. \url{https://proceedings.mlr.press/v9/murray10a}

Nishihara, R., Murray, I., and Adams, R. P. (2014), "Parallel MCMC with Generalized Elliptical Slice Sampling," \emph{Journal of Machine Learning Research}, 15, 2087-2112. \url{https://jmlr.org/papers/v15/nishihara14a.html}
}
