% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_vcard.R
\name{qr_vcard}
\alias{qr_vcard}
\title{Create a QR code for a vCard}
\usage{
qr_vcard(
  given,
  family,
  address,
  email,
  telephone,
  organisation,
  job_title,
  url,
  gender,
  logo,
  photo,
  middle = character(0),
  prefix = character(0),
  suffix = character(0),
  ecl = c("L", "M", "Q", "H"),
  ...
)
}
\arguments{
\item{given}{The given name.}

\item{family}{The family name.}

\item{address}{In case of a single address, a named character vector with
the following elements: \code{street_nr}, \code{city}, \code{region}, \code{postal_code} and
\code{country}.
In case of multiple addresses, a named list of named character
vectors.
The names of the list are used as the type of the address.}

\item{email}{Optionally one or more email addresses.
The names of the vector are used as the type of the email address.}

\item{telephone}{Optionally one of more telephone numbers.
The names of the vector are used as the type of the telephone number.}

\item{organisation}{Optionally the name of your organisation and team within
the organisation.}

\item{job_title}{Optionally the job title of the person.}

\item{url}{Optionally one or more URLs.
The names of the vector are used as the type of the URL.}

\item{gender}{Optionally a string describing the gender of the person.}

\item{logo}{Optionally a URL to a logo.}

\item{photo}{Optionally a URL to a photo.}

\item{middle}{Optionally one or more middle names.}

\item{prefix}{Optionally one or more prefixes.}

\item{suffix}{Optionally one or more suffixes.}

\item{ecl}{the required error correction level.
Available options are \code{"L"} (7\%), \code{"M"} (15\%), \code{"Q"} (25\%) and \code{"H"} (30\%).
Defaults to \code{"L"}.}

\item{...}{Additional arguments are silently ignored.}
}
\description{
Create a QR code for a vCard
}
