% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_effects.R
\name{conditional_effects.qbrms_fit}
\alias{conditional_effects.qbrms_fit}
\title{Conditional effects for qbrms Gaussian models}
\usage{
\method{conditional_effects}{qbrms_fit}(
  object,
  effects = NULL,
  spaghetti = FALSE,
  ndraws = 200L,
  n_points = 100L,
  at = list(),
  seed = NULL,
  prob = 0.95,
  ...
)
}
\arguments{
\item{object}{A qbrms fit object (Gaussian).}

\item{effects}{Character vector: names of predictors to vary. Supports simple
two-way interactions "num:fac" or "fac:num" where one is numeric and the other factor.}

\item{spaghetti}{Logical; if TRUE draw per-draw "spaghetti" lines. If FALSE,
draw a mean line with a credible-interval ribbon.}

\item{ndraws}{Number of joint coefficient draws for uncertainty (default 200).}

\item{n_points}{Size of the x-grid across the observed range (default 100).}

\item{at}{Optional named list of covariate values to hold constant.}

\item{seed}{Optional integer seed for reproducibility.}

\item{prob}{Interval probability for ribbons (default 0.95).}

\item{...}{Ignored.}
}
\value{
An object of class \code{"qbrms_conditional_effects"} containing
a list with one element per effect. Each element is a data frame with
columns for the predictor values, point estimates (\code{estimate__}),
and credible interval bounds (\code{lower__}, \code{upper__}).
}
\description{
Conditional effects for qbrms Gaussian models
}
