% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalExpRqPCR.R
\name{CalExpRqPCR}
\alias{CalExpRqPCR}
\title{Calculate expression using standard curve.}
\arguments{
\item{cq.table}{The data frame of the position and cq value.}

\item{design.table}{The data frame of the position and corresponding information.}

\item{correction}{Correct expression value by reference gene.}

\item{ref.gene}{The name of reference gene.}

\item{ref.group}{The name of reference group.}

\item{stat.method}{Statistical method.}

\item{fig.type}{Output image type, `box` represents `boxplot`, `bar` represents `barplot`.}

\item{fig.ncol}{Number of columes of figure.}
}
\value{
A list contain a table and a figure.
}
\description{
Calculate expression using standard curve.
}
\examples{
df1.path <- system.file("examples", "cal.expre.rqpcr.cq.txt", package = "qPCRtools")
df2.path <- system.file("examples", "cal.expre.rqpcr.design.txt", package = "qPCRtools")

cq.table <- read.table(df1.path, header = TRUE)
design.table <- read.table(df2.path, header = TRUE)

CalExpRqPCR(cq.table,
           design.table,
           ref.gene = NULL,
           ref.group = "CK",
           stat.method = "t.test",
           fig.type = "box",
           fig.ncol = NULL
           ) -> res

res[["table"]]
res[["figure"]]

}
\author{
Xiang LI <lixiang117423@gmail.com>
}
