% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{CI.algorithm}
\alias{CI.algorithm}
\title{The CI.algorithm function}
\usage{
CI.algorithm(
  dat,
  family = NA,
  nesting = NA,
  smooth = TRUE,
  alpha.reject = 0.05,
  constrained.edges = NA,
  write.result = TRUE
)
}
\arguments{
\item{dat}{A data frame containing the variables for which a partially-
oriented dependency graph is sought.  All variables in this data frame
will be used except for those listed in the nesting= argument; these
variables describe the nesting structure (if present) of the other
variables.}

\item{family}{A  data frame giving the name of the distributional type
of each variable that is not Gaussian. Example: data.frame(X1="binomial")
if all variables except X1 are Gaussian but X1 is binomial.}

\item{nesting}{A named list.  Each name in the list is the name of the variable
in the data set (except for the nesting= variables) followed by a character
vector giving the names of the variables in dat holding the nesting structure.
The default is nesting=NA, which is used if there are no nesting variables.}

\item{smooth}{A logical value stating if linear (or generalized linear)
links between the variables are assumed (smooth=FALSE) or not (smooth=FALSE).
The default is smooth=TRUE, in which case generalized additive models are
used to measure conditional independence and therefore non-linear relationships
are assumed.}

\item{alpha.reject}{A numerical value between 0 and 1 giving the
"significance level" to use when judging (conditional) independence.  The
default value is alpha.reject=0.05.}

\item{constrained.edges}{A character object giving the edges that
must be constrained to not exist ("X|Y"),  or X is a causal parent of Y
("X->Y") or X and Y have a common latent parent ("X<->Y"). Default is
constrained.edges=NA (no edges are constrained).}

\item{write.result}{A logical value indicating if you want the resulting
partially-oriented dependency graph to be output to the screen
(write.result = T) or just the adjacency matrix returned as output.  The
default value is write.result = T.}
}
\value{
Just the partially-oriented graph output to the screen or
just the adjacency matrix as a binary (0/1) matrix
}
\description{
This function impliments the exploratory method of causal
discovery called the CI (Causal Inference) algorithm of Pearl.
}
\examples{
set.seed(11)
X1<-rnorm(500)
X2<-0.5*X1+rnorm(500,0,sqrt(1-0.5^2))
X3<-0.5*X2+rnorm(500,0,sqrt(1-0.5^2))
X4<-0.5*X2+rnorm(500,0,sqrt(1-0.5^2))
X5<-0.5*X3+0.5*X4+rnorm(500,0,sqrt(1-2*0.5^2))
my.dat<-data.frame(X1,X2,X3,X4,X5)
CI.algorithm(dat=my.dat,smooth=FALSE,alpha.reject=0.05)
}
