% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeInterval.R
\name{TimeInterval}
\alias{TimeInterval}
\title{Time Interval}
\usage{
TimeInterval(data, sample = "sample", date.and.time = "date.and.time")
}
\arguments{
\item{data}{data frame containing at least a column giving the time (and date) (class POSIXct) of the measurements ordered by
sample and chronologically. A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample ID, default: "sample"}

\item{date.and.time}{optional name of the column in data containing the time (and date) as class POSIXct,
default: "date.and.time"}
}
\value{
the original data frame extended by a numerical vecor containing the time intervals
(min) between the measurements of a sample. The first values of each sample is NA since
time intervals are computed from row i and i-1.
}
\description{
Calculates time intervals (min) between temporally repeated measurements
}
\examples{
# get example data
df <- leaf_drying_data

# extend df by time interval
df_with_ti <- TimeInterval(df)

}
