% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWSaturated.R
\name{FWSaturated}
\alias{FWSaturated}
\title{Saturated fresh weight estimation}
\usage{
FWSaturated(data, sample = "sample",
  water.potential = "water.potential", fresh.weight = "fresh.weight",
  dry.weight = "dry.weight")
}
\arguments{
\item{data}{data frame, at least with a column containing numeric water potential (bar), fresh.weight (g) and dry.weight (g) values,
ordered by sample by descending water potential.
A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample IDs, default: "sample"}

\item{water.potential}{optional name of the column in data containing the water potential values (bar), default = "water.potential"}

\item{fresh.weight}{optional name of the column in data containing the fresh weight values (g), default: "fresh weight"}

\item{dry.weight}{optional name of the column containing the dry weight values (g), default: "dry.weight"}
}
\value{
the original data frame (data) extended by a numeric column containing the saturated fresh weight values ("fresh.weight.saturated")
}
\description{
Calculates saturated fresh weight by fitting fresh weight values above the turgor loss point linearly to water potential values.
}
\details{
Above the turgor loss point, a linear relationship between water content and water potential exists. Based on this premise,
saturated water content is found where water potential is zero. First, turgor loss point is calculated based on the relative leaf water
loss (fresh weight minus dry weight relativized by the maximum
leaf water content value). Then, data above the turgor loss point is extracted and fresh weight is fitted linearly to water potential.
The point where water potential of the linear regression line is zero is the saturated water content.
}
\examples{
# get example data
df <- pressure_volume_data
# extend the data frame by saturated fresh weight
df <- FWSaturated(df)

}
