% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaporPressureDeficit.R
\name{VaporPressureDeficit}
\alias{VaporPressureDeficit}
\title{Vapor Pressure Deficit (VPD)}
\usage{
VaporPressureDeficit(data, humidity = "humidity",
  temperature = "temperature", atmospheric.pressure = 101.325)
}
\arguments{
\item{data}{data frame at least with two numeric columns of equal length containg humidity (\%)
and temperature (degree Celsius)}

\item{humidity}{optional name of the column in data containing the humidity values;
default: "humidity"}

\item{temperature}{optional name of the column in data containing the temperature values;
default: "temperature"}

\item{atmospheric.pressure}{optional; default = 101.325 (atmospheric pressure at sea level)}
}
\value{
The original data frame extended by a numeric column with the vapor pressure deficit
(mol * mol^-1).
}
\description{
Calculates mole fraction vapor pressure deficit (mol * mol^-1) of the air.
}
\details{
Mole fraction vapor pressure deficit is calculated as:
\deqn{(1 - RH / 100) * (VPsat / AP)}
whereas RH = relative humidity (\%), VPsat = saturation vapor pressure (kPA),
AP = atmospheric pressure (kPA), whereas:
\deqn{VPsat = 0.61121 exp ((18.678 - T 234.5^-1) (T 257.14 + T))}
where T = air temperature (degree Celsius)
}
\examples{
# get example data
df <- weather_data

# calculate vapor pressure deficit from weather data measured at sea level
df_with_VPD <- VaporPressureDeficit(df)

# calculate vapor pressure deficit from weather data measured at 2000 m altitude
df_with_VPD <- VaporPressureDeficit(df, atmospheric.pressure = 79.495)

}
